/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.util;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public class RxJavaUtils {
    @NonNull
    public static @NonNull Function<? super Flowable<Throwable>, @NonNull ? extends Publisher<@NonNull ?>> retryWithExponentialBackoff(int maxRetries, long initialDelayMillis, Throwable ... existingErrors) {
        List throwableList = Collections.synchronizedList(new ReferenceArrayList());
        throwableList.addAll(List.of(existingErrors));
        return errors -> errors.zipWith((Publisher)Flowable.range((int)1, (int)(maxRetries + 1)), (error, retryCount) -> {
            throwableList.add(error);
            if (retryCount > maxRetries) {
                StacklessRuntimeException exception = new StacklessRuntimeException("Max retries reached");
                throwableList.forEach(exception::addSuppressed);
                throw exception;
            }
            return retryCount;
        }).flatMap(retryCount -> Flowable.timer((long)((long)Math.pow(2.0, retryCount - 1) * initialDelayMillis), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public static class StacklessRuntimeException
    extends RuntimeException {
        public StacklessRuntimeException(String message) {
            super(message, null, true, false);
        }
    }
}

